/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ISiteConnectionManager;
import com.aptana.ide.syncing.core.Messages;
import com.aptana.ide.syncing.core.SiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISiteConnectionListener;
import com.aptana.ide.syncing.core.events.SiteConnectionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SiteConnectionManager
implements ISiteConnectionManager {
    protected static final String STATE_FILENAME = "sites";
    private static final String ELEMENT_ROOT = "sites";
    private static final String ELEMENT_SITE = "site";
    private static SiteConnectionManager instance;
    private List<SiteConnection> connections = Collections.synchronizedList(new ArrayList());
    private boolean dirty = false;
    private ListenerList listeners = new ListenerList();

    private SiteConnectionManager() {
    }

    public static SiteConnectionManager getInstance() {
        if (instance == null) {
            instance = new SiteConnectionManager();
        }
        return instance;
    }

    void loadState(IPath path) {
        File file = path.toFile();
        if (file.exists()) {
            this.connections.clear();
            this.addConnectionsFrom(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveState(IPath path) {
        block16: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"sites");
            List<SiteConnection> list = this.connections;
            synchronized (list) {
                for (SiteConnection siteConnection : this.connections) {
                    IMemento child = memento.createChild(ELEMENT_SITE);
                    child.putMemento(this.storeConnection(siteConnection));
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                    this.isChanged();
                }
                catch (IOException iOException) {
                    if (writer == null) break block16;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public List<ISiteConnection> addConnectionsFrom(IPath path) {
        List<ISiteConnection> newConnections = this.readConnectionsFrom(path);
        for (ISiteConnection connection : newConnections) {
            this.connections.add((SiteConnection)connection);
        }
        return newConnections;
    }

    @Override
    public List<ISiteConnection> readConnectionsFrom(IPath path) {
        ArrayList<ISiteConnection> newConnections;
        block16: {
            newConnections = new ArrayList<ISiteConnection>();
            File file = path.toFile();
            if (file.exists()) {
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(file);
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = memento.getChildren(ELEMENT_SITE);
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            SiteConnection siteConnection = this.restoreConnection(child);
                            if (siteConnection != null && siteConnection.isValid()) {
                                newConnections.add(siteConnection);
                            } else {
                                IdeLog.logWarning((Plugin)SyncingPlugin.getDefault(), (String)"Failed to load the site connection due to either source or destination being invalid", (String)"com.aptana.syncing.core/debug");
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (String)Messages.SiteConnectionManager_ERR_FailedToLoadConnections, (Throwable)e);
                        if (reader == null) break block16;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return newConnections;
    }

    private IMemento storeConnection(SiteConnection siteConnection) {
        IMemento saveMemento = XMLMemento.createWriteRoot((String)"sites").createChild(ELEMENT_SITE);
        siteConnection.saveState(saveMemento);
        return saveMemento;
    }

    private SiteConnection restoreConnection(IMemento memento) {
        SiteConnection siteConnection = new SiteConnection();
        siteConnection.loadState(memento);
        return siteConnection;
    }

    public boolean isChanged() {
        for (SiteConnection siteConnection : this.connections) {
            if (!siteConnection.isChanged()) continue;
            this.dirty = true;
        }
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    @Override
    public void addSiteConnection(ISiteConnection siteConnection) {
        if (!(siteConnection instanceof SiteConnection)) {
            throw new IllegalArgumentException();
        }
        if (!this.connections.contains(siteConnection)) {
            this.connections.add((SiteConnection)siteConnection);
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 1, siteConnection));
        }
    }

    @Override
    public void removeSiteConnection(ISiteConnection siteConnection) {
        if (this.connections.contains(siteConnection)) {
            this.connections.remove(siteConnection);
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 2, siteConnection));
        }
    }

    @Override
    public void siteConnectionChanged(ISiteConnection siteConnection) {
        if (this.connections.contains(siteConnection)) {
            this.dirty = true;
            this.broadcastEvent(new SiteConnectionEvent(this, 4, siteConnection));
        }
    }

    @Override
    public ISiteConnection cloneSiteConnection(ISiteConnection siteConnection) throws CoreException {
        if (!(siteConnection instanceof SiteConnection)) {
            throw new IllegalArgumentException();
        }
        if (siteConnection == DefaultSiteConnection.getInstance()) {
            SiteConnection clone = new SiteConnection();
            clone.setName(siteConnection.getName());
            clone.setSource(siteConnection.getSource());
            clone.setDestination(siteConnection.getDestination());
            return clone;
        }
        return this.restoreConnection(this.storeConnection((SiteConnection)siteConnection));
    }

    @Override
    public ISiteConnection createSiteConnection() {
        return new SiteConnection();
    }

    @Override
    public ISiteConnection[] getSiteConnections() {
        return this.connections.toArray(new ISiteConnection[this.connections.size()]);
    }

    @Override
    public void addListener(ISiteConnectionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(ISiteConnectionListener listener) {
        this.listeners.add((Object)listener);
    }

    private void broadcastEvent(SiteConnectionEvent event) {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISiteConnectionListener)listener).siteConnectionChanged(event);
            ++n2;
        }
    }
}

